% EXAMPLE taken from the COIN paper of Gaertner, Rodriguez and Toni

% GOAL RULES with the following meaning:
% g1: to produce 100 motorbikes this week
% g2: to always clear the assembly line at the end of each day
% g3: to produce 100 sidecars this week
% g4: to improve/foster relations between the three collaborators
% g5: to make the institution sustainable/repeatable
% g6: to make Carles as the leader of this collaboration

myRule(g1,[a1,x1]).
myRule(g1,[r1,c1,x8]).
myRule(g2,[p1,x2]).
myRule(g2,[q1,x5]).
myRule(g3,[p2,a2,x3]).
myRule(g3,[a3,x4]).
myRule(g4,[b1,q2,x6]).
myRule(g5,[q3,b2,x7]).
myRule(g6,[r2,x9]).


% OTHER RULES (for propositions, beliefs, etc. which have the following meaning):
% p1: no erroneous products
% p2: existing speed delivery with supplier
% q1: working distribution channel
% q2: the collaboration is profitable as a whole
% q3: all collaborators are trustworthy
% r1: a reliable third part producer exists
% r2: Carles is the most senior agent
% r3: MotoTaiwanInc has been reliable in the past
% r4: Carles is unhappy
% r5: Carles is paid poorly for his efforts

myRule(p1,[]).
myRule(p2,[a1]).
myRule(q1,[b3]).
myRule(q2,[]).
myRule(q3,[]).
myRule(not(b2),[]).
myRule(r3,[]).
myRule(not(a3),[r3]).
myRule(not(b1),[r4]).
myRule(r4,[r5,c2]).
myRule(r5,[c3]).


% RULES from the shared knowledge base
myRule(not(a1),[]).	% not sufficiently many spare parts are in stock
myRule(r1,[r3]).	% a reliable third party producer exists if MotoTaiwanInc has been reliable in the past


% ASSUMPTIONS - which have the following meaning:
myAsm(a1).  % sufficiently many bike parts are in stock
myAsm(a2).  % all collaborators agree to use expensive speed delivery
myAsm(a3).  % sufficiently many sidecar parts in stock
myAsm(b1).  % everyone is happy
myAsm(b2).  % at least constant demand for motorcycles
myAsm(b3).  % fair deal with distributors
myAsm(c1).  % outsourcing is acceptable to all collaborators
myAsm(c2).  % Carles' has no reputation increase via the collaboration
myAsm(c3).  % Carles' financial gain is less than 100

% APPLICABILITY ASSUMPTIONS (to refute a goal rule)
myAsm(x1).
myAsm(x2).
myAsm(x3).
myAsm(x4).
myAsm(x5).
myAsm(x6).
myAsm(x7).
myAsm(x8).
myAsm(x9).

% CONTRARY NOTION (simply logical negation here)
contrary(a1,not(a1)).
contrary(a2,not(a2)).
contrary(a3,not(a3)).
contrary(b1,not(b1)).
contrary(b2,not(b2)).
contrary(b3,not(b3)).
contrary(c1,not(c1)).
contrary(c2,not(c2)).
contrary(c3,not(c3)).
contrary(x1,not(x1)).
contrary(x2,not(x2)).
contrary(x3,not(x3)).
contrary(x4,not(x4)).
contrary(x5,not(x5)).
contrary(x6,not(x6)).
contrary(x7,not(x7)).
contrary(x8,not(x8)).
contrary(x9,not(x9)).

% CLAIM TO BE PROVED 
toBeProved([g4]).



